<?php

if(!function_exists('edge_core_is_ajax')) {
    /**
     * Function that checks if current request is ajax request
     * @return bool whether it's ajax request or not
     *
     * @version 0.1
     */
    function edge_core_is_ajax() {
        return !empty( $_SERVER[ 'HTTP_X_REQUESTED_WITH' ]) && strtolower( $_SERVER[ 'HTTP_X_REQUESTED_WITH' ]) == 'xmlhttprequest';
    }
}

if(!function_exists('edge_core_remove_yoast_json_on_ajax')) {
    /**
     * Function that removes yoast json ld script
     * that stops page transition to work on home page
     * Hooks to wpseo_json_ld_output in order to disable json ld script
     * @return bool
     *
     * @param $data array json ld data that is being passed to filter
     *
     * @version 0.2
     */
    function edge_core_remove_yoast_json_on_ajax($data) {
        //is current request made through ajax?
        if(edge_core_is_ajax()) {
            //disable json ld script
            return array();
        }

        return $data;
    }

    //is yoast installed and it's version is greater or equal of 1.6?
    if(defined('WPSEO_VERSION') && version_compare(WPSEO_VERSION, '1.6') >= 0) {
        add_filter('wpseo_json_ld_output', 'edge_core_remove_yoast_json_on_ajax');
    }
}

if( ! function_exists('edge_core_add_inline_html_after_content') ){
    function edge_core_add_inline_html_after_content(){
        global $hudson_edge_options;
        $id = hudson_edge_get_page_id();
        $animation = get_post_meta($id, "edgt_show-animation", true);

        ?>
        <?php if($hudson_edge_options['page_transitions'] == "1" || $hudson_edge_options['page_transitions'] == "2" || $hudson_edge_options['page_transitions'] == "3" || $hudson_edge_options['page_transitions'] == "4" || ($animation == "updown") || ($animation == "fade") || ($animation == "updown_fade") || ($animation == "leftright")){ ?>
            <div class="meta">
                <?php do_action('edgt_ajax_meta'); ?>
                <span id="edgt_page_id"><?php echo esc_html($id); ?></span>
                <div class="body_classes"><?php echo esc_html(implode( ',', get_body_class())); ?></div>
            </div>
        <?php }
    }

    add_action('hudson_qode_after_content_begin', 'edge_core_add_inline_html_after_content');
}

if( ! function_exists('edge_core_get_content_classes') ) {
    function edge_core_get_content_classes($content_class){

        global $hudson_edge_options;
        extract(hudson_edge_get_header_variables());
        $id = hudson_edge_get_page_id();

        $is_title_area_visible = true;
        if(get_post_meta($id, "edgt_show-page-title", true) == 'yes') {
            $is_title_area_visible = true;
        } elseif(get_post_meta($id, "edgt_show-page-title", true) == 'no') {
            $is_title_area_visible = false;
        } elseif(get_post_meta($id, "edgt_show-page-title", true) == '' && (isset($hudson_edge_options['show_page_title']) && $hudson_edge_options['show_page_title'] == 'yes')) {
            $is_title_area_visible = true;
        } elseif(get_post_meta($id, "edgt_show-page-title", true) == '' && (isset($hudson_edge_options['show_page_title']) && $hudson_edge_options['show_page_title'] == 'no')) {
            $is_title_area_visible = false;
        } elseif(isset($hudson_edge_options['show_page_title']) && $hudson_edge_options['show_page_title'] == 'yes') {
            $is_title_area_visible = true;
        }
        if((get_post_meta($id, "edgt_revolution-slider", true) == "" && ($header_transparency == '' || $header_transparency == 1))  || get_post_meta($id, "edgt_enable_content_top_margin", true) == "yes" ){
            if($hudson_edge_options['header_bottom_appearance'] == "fixed" || $hudson_edge_options['header_bottom_appearance'] == "fixed_hiding" || $hudson_edge_options['header_bottom_appearance'] == "fixed fixed_minimal"){
                $content_class .= " content_top_margin";
            }else {
                $content_class .= " content_top_margin_none";
            }
        }

        if(isset($hudson_edge_options['header_bottom_appearance']) && ($hudson_edge_options['header_bottom_appearance'] == "stick" || $hudson_edge_options['header_bottom_appearance'] == "stick menu_bottom" || $hudson_edge_options['header_bottom_appearance'] == "stick_with_left_right_menu" || $hudson_edge_options['header_bottom_appearance'] == "stick compound")){
            if(get_post_meta(hudson_edge_get_page_id(), "edgt_page_hide_initial_sticky", true) !== ''){
                if(get_post_meta(hudson_edge_get_page_id(), "edgt_page_hide_initial_sticky", true) == 'yes'){
                    $content_class .= " ";
                }
            }else if(isset($hudson_edge_options['hide_initial_sticky']) && $hudson_edge_options['hide_initial_sticky'] == 'yes') {
                $content_class .= " ";
            }
        }


        if(hudson_edge_get_page_template_name() == "full_screen"){
            // solution for top header
            if(!hudson_edge_is_side_header()){
                if (($header_transparency == '' || $header_transparency == 1) || ($hudson_edge_options['header_bottom_appearance'] == "regular" || $hudson_edge_options['header_bottom_appearance'] == "fixed_top_header")) {
                    if ($hudson_edge_options['header_bottom_appearance'] == "fixed" || $hudson_edge_options['header_bottom_appearance'] == "fixed_hiding" || $hudson_edge_options['header_bottom_appearance'] == "fixed fixed_minimal") {
                        $content_class .= " content_top_margin_none";
                    }
                    elseif($hudson_edge_options['header_bottom_appearance'] == 'stick menu_bottom'){
                        $content_class .= " "; // delete class if exists
                    }
                    else {
                        $content_class .= " content_top_margin_negative content_top_margin_none";
                    }
                }
            }

            // solution for paspartu on side and top header
            if((isset($hudson_edge_options['paspartu']) && $hudson_edge_options['paspartu'] == 'yes') && (isset($hudson_edge_options['paspartu_on_top']) && $hudson_edge_options['paspartu_on_top'] == 'yes')){
                if(isset($hudson_edge_options['paspartu_on_top_fixed']) && $hudson_edge_options['paspartu_on_top_fixed'] == 'yes'){
                    if(!(hudson_edge_is_side_header() && (isset($hudson_edge_options['vertical_menu_inside_paspartu']) && $hudson_edge_options['vertical_menu_inside_paspartu'] == 'yes'))){ // not for this case
                        $content_class .= " content_top_margin_vm_paspartu";
                    }
                }
                else{
                    // not resolved
                }
            }
        }

        //check if there is slider added and set class to content div, this is used for content top margin in style_dynamic.php
        if(get_post_meta($id, "edgt_revolution-slider", true) != ""){
            $content_class .= " has_slider";
        }

        return $content_class;
    }

    add_filter('hudson_edge_content_classes', 'edge_core_get_content_classes');
}

if( ! function_exists('edge_core_get_content_inner_classes') ) {
    function edge_core_get_content_inner_classes($content_inner_class){
        $id = hudson_edge_get_page_id();
        $animation = get_post_meta($id, "edgt_show-animation", true);

        $content_inner_class .= ' ' . $animation;

        return $content_inner_class;
    }

    add_filter('hudson_edge_content_inner_classes', 'edge_core_get_content_inner_classes');
}

if(!function_exists('edge_core_ajax_meta')) {
    /**
     * Function that echoes meta data for ajax
     *
     * @since 4.3
     * @version 0.2
     */
    function edge_core_ajax_meta() {
        global $hudson_edge_options;
        global $is_IE;

        if ( $is_IE ) { ?>
            <meta content="IE=edge,chrome=1" http-equiv="X-UA-Compatible">
        <?php }

        $seo_description = get_post_meta(hudson_edge_get_page_id(), "edgt_seo_description", true);
        $seo_keywords = get_post_meta(hudson_edge_get_page_id(), "edgt_seo_keywords", true);
        ?>

        <div class="seo_title"><?php wp_title('|', true, 'right'); ?></div>

        <?php if($seo_description !== ''){ ?>
            <div class="seo_description"><?php echo esc_html($seo_description); ?></div>
        <?php } else if($hudson_edge_options['meta_description']){?>
            <div class="seo_description"><?php echo esc_html($hudson_edge_options['meta_description']); ?></div>
        <?php } ?>
        <?php if($seo_keywords !== ''){ ?>
            <div class="seo_keywords"><?php echo esc_html($seo_keywords); ?></div>
        <?php }else if($hudson_edge_options['meta_keywords']){?>
            <div class="seo_keywords"><?php echo esc_html($hudson_edge_options['meta_keywords']); ?></div>
        <?php }
    }

    add_action('edgt_ajax_meta', 'edge_core_ajax_meta');
}

if(!function_exists('edge_core_header_meta')) {
    /**
     * Function that echoes meta data if our seo is enabled
     */
    function edge_core_header_meta() {
        global $hudson_edge_options;

        if(hudson_edge_is_seo_enabled()) {
            $seo_description = get_post_meta(hudson_edge_get_page_id(), "edgt_seo_description", true);
            $seo_keywords = get_post_meta(hudson_edge_get_page_id(), "edgt_seo_keywords", true);
            ?>

            <?php if($seo_description) { ?>
                <meta name="description" content="<?php echo esc_html($seo_description); ?>">
            <?php } else if($hudson_edge_options['meta_description']){ ?>
                <meta name="description" content="<?php echo esc_html($hudson_edge_options['meta_description']) ?>">
            <?php } ?>

            <?php if($seo_keywords) { ?>
                <meta name="keywords" content="<?php echo esc_html($seo_keywords); ?>">
            <?php } else if($hudson_edge_options['meta_keywords']){ ?>
                <meta name="keywords" content="<?php echo esc_html($hudson_edge_options['meta_keywords']) ?>">
            <?php }
        } ?>

        <meta charset="<?php bloginfo( 'charset' ); ?>" />
        <?php
        if ( !empty(getenv('HTTP_USER_AGENT')) && (strpos(getenv('HTTP_USER_AGENT'), 'MSIE') !== false))
            echo('<meta content="IE=edge,chrome=1" http-equiv="X-UA-Compatible">');
        ?>

        <link rel="profile" href="http://gmpg.org/xfn/11" />
        <link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
        <?php

        $favicon = get_option( 'site_icon' );
        if ( empty( $favicon ) && $hudson_edge_options['favicon_image'] !== '' ) { ?>
            <link rel="shortcut icon" type="image/x-icon" href="<?php echo esc_url($hudson_edge_options['favicon_image']); ?>">
            <link rel="apple-touch-icon" href="<?php echo esc_url($hudson_edge_options['favicon_image']); ?>"/>
        <?php }
    }

    add_action('edgt_header_meta', 'edge_core_header_meta');
}

if(!function_exists('edge_core_user_scalable_meta')) {
    /**
     * Function that outputs user scalable meta if responsiveness is turned on
     * Hooked to edgt_header_meta action
     */
    function edge_core_user_scalable_meta() {
        //is responsiveness option is chosen?
        if (hudson_edge_is_responsive_on()) { ?>
            <meta name="viewport" content="width=device-width,initial-scale=1,user-scalable=no">
        <?php }	else { ?>
            <meta name="viewport" content="width=1200,user-scalable=no">
        <?php }
    }

    add_action('edgt_header_meta', 'edge_core_user_scalable_meta');
}

if(!function_exists('edge_core_maintenance_mode')) {
    /**
     * Function that redirects user to desired landing page if maintenance mode is turned on in options
     */
    function edge_core_maintenance_mode() {
        global $hudson_edge_options;

        $protocol = is_ssl() ? "https://" : "http://";
        if(isset($hudson_edge_options['edgt_maintenance_mode']) && $hudson_edge_options['edgt_maintenance_mode'] == 'yes' && isset($hudson_edge_options['edgt_maintenance_page']) && $hudson_edge_options['edgt_maintenance_page'] != ""
            && !in_array($GLOBALS['pagenow'], array('wp-login.php', 'wp-register.php'))
            && !is_admin()
            && !is_user_logged_in()
            && $protocol.getenv('SERVER_NAME').getenv('REQUEST_URI') != get_permalink($hudson_edge_options['edgt_maintenance_page'])
        ) {

            wp_redirect(get_permalink($hudson_edge_options['edgt_maintenance_page']));
            exit;
        }
    }
}

if(!function_exists('edge_core_initial_maintenance')) {
    /**
     * Function that initalize maintenance function
     */
    function edge_core_initial_maintenance() {
        global $hudson_edge_options;

        if(isset($hudson_edge_options['edgt_maintenance_mode']) && $hudson_edge_options['edgt_maintenance_mode'] == 'yes') {
            add_action('init', 'edge_core_maintenance_mode', 2);
        }
    }

    add_action('init', 'edge_core_initial_maintenance', 1);
}

if(!function_exists('edge_core_visual_composer_custom_shortcodce_css')) {
    /**
     * Function that adds Visual composer's custom css to our action. Needed for ajax page transitions
     */
    function edge_core_visual_composer_custom_shortcodce_css() {
        if(hudson_edge_visual_composer_installed()) {
            if(is_page() || is_single() || is_singular('portfolio_page')) {

                $shortcodes_custom_css = get_post_meta( hudson_edge_get_page_id(), '_wpb_shortcodes_custom_css', true );
                if ( ! empty( $shortcodes_custom_css ) ) {
                    echo '<style type="text/css" data-type="vc_shortcodes-custom-css-'.esc_attr(hudson_edge_get_page_id()).'">';
                    echo get_post_meta( hudson_edge_get_page_id(), '_wpb_shortcodes_custom_css', true );
                    echo '</style>';
                }

                $post_custom_css = get_post_meta( hudson_edge_get_page_id(), '_wpb_post_custom_css', true );
                if ( ! empty( $post_custom_css ) ) {
                    echo '<style type="text/css" data-type="vc_custom-css-'.esc_attr(hudson_edge_get_page_id()).'">';
                    echo get_post_meta( hudson_edge_get_page_id(), '_wpb_post_custom_css', true );
                    echo '</style>';
                }
            }
        }
    }

    add_action('edgt_visual_composer_custom_shortcodce_css', 'edge_core_visual_composer_custom_shortcodce_css');
}