<?php
/*
Plugin Name: Hudson Instagram Feed
Description: Plugin that adds Instagram feed functionality to our theme
Author: Edge Themes
Version: 1.0
*/

define( 'HUDSON_INSTAGRAM_FEED_VERSION', '1.0');
define( 'HUDSON_INSTAGRAM_ABS_PATH', dirname(__FILE__));
define( 'HUDSON_INSTAGRAM_REL_PATH', dirname(plugin_basename(__FILE__ )));
define( 'HUDSON_INSTAGRAM_URL_PATH', plugin_dir_url( __FILE__ ) );
define( 'HUDSON_INSTAGRAM_ASSETS_PATH', HUDSON_INSTAGRAM_ABS_PATH . '/assets' );
define( 'HUDSON_INSTAGRAM_ASSETS_URL_PATH', HUDSON_INSTAGRAM_URL_PATH . 'assets' );
define( 'HUDSON_INSTAGRAM_SHORTCODES_PATH', HUDSON_INSTAGRAM_ABS_PATH . '/shortcodes' );
define( 'HUDSON_INSTAGRAM_SHORTCODES_URL_PATH', HUDSON_INSTAGRAM_URL_PATH . 'shortcodes' );

include_once 'load.php';

if ( ! function_exists('hudson_instagram_feed_theme_installed') ) {
    /**
     * Checks whether theme is installed or not
     * @return bool
     */
    function hudson_instagram_feed_theme_installed() {
        return defined( 'HUDSON_EDGE' );
    }
}

if ( ! function_exists( 'hudson_instagram_feed_text_domain' ) ) {
	/**
	 * Loads plugin text domain so it can be used in translation
	 */
	function hudson_instagram_feed_text_domain() {
		load_plugin_textdomain( 'hudson-instagram-feed', false, HUDSON_INSTAGRAM_REL_PATH . '/languages' );
	}
	
	add_action( 'plugins_loaded', 'hudson_instagram_feed_text_domain' );
}